// Generated by CoffeeScript 1.10.0
(function() {
  var findMode, handlers, setTextInInputElement;

  findMode = null;

  setTextInInputElement = function(inputElement, text) {
    var range, selection;
    inputElement.textContent = text;
    range = document.createRange();
    range.selectNodeContents(inputElement);
    range.collapse(false);
    selection = window.getSelection();
    selection.removeAllRanges();
    return selection.addRange(range);
  };

  document.addEventListener("keydown", function(event) {
    var inputElement, key, rawQuery, ref, ref1, transferrableEvent, value;
    inputElement = document.getElementById("hud-find-input");
    if (inputElement == null) {
      return;
    }
    transferrableEvent = {};
    for (key in event) {
      value = event[key];
      if ((ref = typeof value) === "number" || ref === "string") {
        transferrableEvent[key] = value;
      }
    }
    if ((((ref1 = event.keyCode) === keyCodes.backspace || ref1 === keyCodes.deleteKey) && inputElement.textContent.length === 0) || event.keyCode === keyCodes.enter || KeyboardUtils.isEscape(event)) {
      UIComponentServer.postMessage({
        name: "hideFindMode",
        event: transferrableEvent,
        query: findMode.rawQuery
      });
    } else if (event.keyCode === keyCodes.upArrow) {
      if (rawQuery = FindModeHistory.getQuery(findMode.historyIndex + 1)) {
        findMode.historyIndex += 1;
        if (findMode.historyIndex === 0) {
          findMode.partialQuery = findMode.rawQuery;
        }
        setTextInInputElement(inputElement, rawQuery);
        findMode.executeQuery();
      }
    } else if (event.keyCode === keyCodes.downArrow) {
      findMode.historyIndex = Math.max(-1, findMode.historyIndex - 1);
      rawQuery = 0 <= findMode.historyIndex ? FindModeHistory.getQuery(findMode.historyIndex) : findMode.partialQuery;
      setTextInInputElement(inputElement, rawQuery);
      findMode.executeQuery();
    } else {
      return;
    }
    DomUtils.suppressEvent(event);
    return false;
  });

  handlers = {
    show: function(data) {
      document.getElementById("hud").innerText = data.text;
      document.getElementById("hud").classList.add("vimiumUIComponentVisible");
      return document.getElementById("hud").classList.remove("vimiumUIComponentHidden");
    },
    hide: function() {
      document.getElementById("hud").innerText = "";
      document.getElementById("hud").classList.add("vimiumUIComponentHidden");
      return document.getElementById("hud").classList.remove("vimiumUIComponentVisible");
    },
    showFindMode: function(data) {
      var countElement, executeQuery, hud, inputElement, ref;
      hud = document.getElementById("hud");
      hud.innerText = "/\u200A";
      inputElement = document.createElement("span");
      inputElement.contentEditable = "plaintext-only";
      setTextInInputElement(inputElement, (ref = data.text) != null ? ref : "");
      inputElement.id = "hud-find-input";
      hud.appendChild(inputElement);
      inputElement.addEventListener("input", executeQuery = function(event) {
        findMode.rawQuery = inputElement.textContent.replace("\u00A0", " ");
        return UIComponentServer.postMessage({
          name: "search",
          query: findMode.rawQuery
        });
      });
      countElement = document.createElement("span");
      countElement.id = "hud-match-count";
      hud.appendChild(countElement);
      inputElement.focus();
      UIComponentServer.postMessage({
        name: "search",
        query: inputElement.textContent.replace("\u00A0", " ")
      });
      return findMode = {
        historyIndex: -1,
        partialQuery: "",
        rawQuery: "",
        executeQuery: executeQuery
      };
    },
    updateMatchesCount: function(arg) {
      var countElement, countText, matchCount, showMatchText;
      matchCount = arg.matchCount, showMatchText = arg.showMatchText;
      countElement = document.getElementById("hud-match-count");
      if (countElement == null) {
        return;
      }
      countText = matchCount > 0 ? " (" + matchCount + " Match" + (matchCount === 1 ? "" : "es") + ")" : " (No matches)";
      return countElement.textContent = showMatchText ? countText : "";
    }
  };

  UIComponentServer.registerHandler(function(event) {
    var data, name;
    data = event.data;
    return typeof handlers[name = data.name] === "function" ? handlers[name](data) : void 0;
  });

  FindModeHistory.init();

}).call(this);
